function [a]=sens_plot4(skt,n,dsr);
%function [a]=sens_plot4(skt,n,dsr);
% Ian Stothers May 2018
  if (nargin==1)
    dsr=100;
      n=1000;
  end

  fbw=1/dsr;
  pkg load signal;
  ntaps=3/fbw;
  ntaps=(floor(ntaps/2)*2)+1;
  bb=fir1(ntaps-1,fbw);
  figure(1);
  freqz(bb,1);
  sr=1000.0; %sample rate
  sp=1/sr;
  ds_sp=sp*dsr;  %down sample sample rate
  
sinlength=10000.0/32768.0;
[a,ptr]=GetSensData1(skt,1);
[a,ptr]=GetSensData1(skt,ptr);

  idx=find(a>32767.0);
  msa=max(size(a));
  a(idx)=a(idx)-65536;
  a=a*sinlength;

pos=mean(a)*ones(1,n);
[fpos,sf]=filter(bb,1,pos);
ppos=[ pos' fpos'];

figure(2);
snum=1:max(size(pos));
t=(snum-1)'*sp;
numsamps=max(snum);
phdl=plot(t,ppos);
s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
s=[s sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)))];
ylabel('um');
xlabel('Time (Secs)')
thdl=title(s);
grid on;

figure(3);
ds_pos=mean(a)*ones(1,n);
ds_snum=1:max(size(ds_pos));
ds_t=(ds_snum-1)'*ds_sp;
ds_phdl=plot(ds_t,ds_pos);
ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(ds_pos),sqrt(var(ds_pos)));
ylabel('um');
xlabel('Time (Secs)')
ds_thdl=title(ds_s);
grid on;


while (size(kbhit(1))(1)<1) 
  [a,ptr]=GetSensData1(skt,ptr);
  idx=find(a>32767.0);
  msa=max(size(a));
  a(idx)=a(idx)-65536;
  a=a*sinlength;
  if(max(size(a))>0)
   [fa,sf]=filter(bb,1,a,sf);
   pos=[pos((msa+1):end) a];
   fpos=[fpos((msa+1):end) fa];
   idx=(1:msa)+numsamps;
   numsamps=numsamps+msa;
   idx=find(rem(idx,dsr)==0);
   ds_a=fa(idx);
   msdsa=max(size(ds_a));
   if(min(size(ds_a))>0)
    ds_pos=[ds_pos((msdsa+1):end) ds_a];
   end
   s=sprintf('un-filtered mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
   s=[s sprintf('       filtered mean pos= %2.4fum  rms=%2.4fum',mean(fpos),sqrt(var(fpos)))];
   set(thdl,'string',s);
   set(phdl(1),'ydata',pos');
   set(phdl(2),'ydata',fpos');
 
   ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(ds_pos),sqrt(var(ds_pos)));
   set(ds_phdl,'ydata',ds_pos');
   set(ds_thdl,'string',ds_s);
   figure(3);
   ax=axis();
   ax(3)=floor(min(ds_pos)-1);
   ax(4)=ceil(max(ds_pos)+1);
   axis(ax);
  
   drawnow;
   end
  end
end
  